Imports conv_to_zugferd.DynaPDF

Module Module1

   Class CConvToPDFA

      Dim m_PDF As CPDF

      Public Sub New()
         MyBase.New()
         m_PDF = New CPDF()
         m_PDF.SetOnErrorProc(AddressOf PDFError)
         ' Set the license key here if you have one
         ' m_PDF.SetLicenseKey("")

         ' Non embedded CID fonts depend usually on the availability of external cmaps.
         ' External cmaps should be loaded if possible.
         m_PDF.SetCMapDir(System.IO.Path.GetFullPath("../../../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)
      End Sub

      Public Function GetPDFInstance() As CPDF
         Return m_PDF
      End Function

      ' Error callback function.
      ' If the function name should not appear at the beginning of the error message then set
      ' the flag emNoFuncNames (pdf.SetErrorMode(CPDF.TErrMode.emNoFuncNames)).
      Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
         Console.WriteLine("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
         Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
      End Function

      Function FontNotFoundProc(ByVal Data As IntPtr, ByVal PDFFont As IntPtr, ByVal FontName As IntPtr, ByVal Style As TFStyle, ByVal StdFontIndex As Integer, ByVal IsSymbolFont As Integer) As Integer
         If m_PDF.WeightFromStyle(Style) < 500 Then
            Style = Style And &HF
            Style = Style Or TFStyle.fsRegular
         End If
         Return m_PDF.ReplaceFont(PDFFont, "Arial", Style, True)
      End Function

      Function ReplaceICCProfileProc(ByVal Data As IntPtr, ByVal Type As TICCProfileType, ByVal ColorSpace As Integer) As Integer
         ' The most important ICC profiles are available free of charge from Adobe. Just seach for "Adobe icc profiles".
         Select Case Type
            Case TICCProfileType.ictRGB
               Return m_PDF.ReplaceICCProfile(ColorSpace, "../../../../test_files/sRGB.icc")
            Case TICCProfileType.ictCMYK
               Return m_PDF.ReplaceICCProfile(ColorSpace, "../../../../test_files/ISOcoated_v2_bas.ICC") ' This is just an example CMYK profile that can be delivered with DynaPDF
            Case Else
               Return m_PDF.ReplaceICCProfile(ColorSpace, "../../../../test_files/gray.icc")
         End Select
      End Function

      Public Function ConvertFile(ByVal Type As TConformanceType, ByVal InFile As String, ByVal Invoice As String, ByVal OutFile As String) As Boolean
         Dim retval As Integer
         Dim convFlags As Integer = TCheckOptions.coDefault_PDFA_3

         Select Case Type
            Case TConformanceType.ctFacturX_Comfort, TConformanceType.ctFacturX_Extended, TConformanceType.ctFacturX_XRechnung
               ' Ok, nothing to do
            Case Else
               Return False
         End Select

         m_PDF.CreateNewPDF(Nothing)                         ' The output file will be created later
         m_PDF.SetDocInfo(TDocumentInfo.diProducer, Nothing) ' No need to override the original producer

         ' These flags require some processing time but they are very useful.
         convFlags = convFlags Or TCheckOptions.coCheckImages
         convFlags = convFlags Or TCheckOptions.coRepairDamagedImages

         ' The flag ifPrepareForPDFA is required. The flag ifImportAsPage makes sure that pages will not be converted to templates.
         m_PDF.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage Or TImportFlags.ifPrepareForPDFA)
         ' The flag if2UseProxy reduces the memory usage.
         m_PDF.SetImportFlags2(TImportFlags2.if2UseProxy)

         retval = m_PDF.OpenImportFile(InFile, TPwdType.ptOpen, Nothing)
         If retval < 0 Then
            If m_PDF.IsWrongPwd(retval) Then
               Console.Write("PDFError File is encrypted!")
            End If
            m_PDF.FreePDF()
            Return False
         End If
         m_PDF.ImportPDFFile(1, 1.0, 1.0)
         m_PDF.CloseImportFile()

         ' The invoice should be the first attachment if further files must be attached.
         ' If the file name of the invoice is not factur-x.xml (case sensitive!) then use AttachFileEx() instead.
         ' In the case of the German XRechnung the file name must be "xrechnung.xml".

         Dim ef As Integer = m_PDF.AttachFile(Invoice, "EN 16931 compliant invoice", False)
         If Type <> TConformanceType.ctFacturX_XRechnung Then
            m_PDF.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef)
         Else
            m_PDF.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arSource, ef)
         End If

         ' An invoice should not use CMYK colors since a CMYK ICC profile must be embedded in this case and such a profile is pretty large!
         ' Note that this code requires the PDF/A Extension for DynaPDF.
         retval = m_PDF.CheckConformance(Type, convFlags, IntPtr.Zero, AddressOf FontNotFoundProc, AddressOf ReplaceICCProfileProc)
         Select Case retval
            Case 1
               m_PDF.AddOutputIntent("../../../../test_files/sRGB.icc")
            Case 2
               m_PDF.AddOutputIntent("../../../../test_files/ISOcoated_v2_bas.ICC")
            Case 3
               m_PDF.AddOutputIntent("../../../../test_files/gray.icc")
         End Select
         ' No fatal error occurred?
         If m_PDF.HaveOpenDoc() Then
            If Not m_PDF.OpenOutputFile(OutFile) Then
               m_PDF.FreePDF()
               Return False
            End If
            Return m_PDF.CloseFile()
         End If
         Return False
      End Function

   End Class

   Sub Main()
      Try
         Dim c As CConvToPDFA = New CConvToPDFA()

         Dim outFile As String = System.IO.Directory.GetCurrentDirectory() + "\out.pdf"

         ' The profiles Minimum, Basic, and Basic WL are not EN 16931 compliant and hence cannot be used to create e-invoices.
         If c.ConvertFile(TConformanceType.ctFacturX_Comfort, "../../../../test_files/test_invoice.pdf", "../../../../test_files/factur-x.xml", outFile) Then
            Dim p As System.Diagnostics.Process = New System.Diagnostics.Process()
            p.StartInfo.FileName = outFile
            p.Start()
         End If
         c = Nothing
      Catch e As Exception
         Console.Write(e.Message + Chr(10))
         Console.Read()
      End Try
   End Sub

End Module
